#####################################################################################
# Drops.py v1.0
#####################################################################################
# Copyright (c) 2003: Weird Juice Software
#####################################################################################
# This File (Drops.py) is released under the terms of the Mozilla Public License (MPL)
#####################################################################################

import poser

from Tkinter import *
import tkMessageBox

root = Tk()

scene = poser.Scene()

version = float(poser.Version())
major_version = int(version)
minor_version = version - major_version

if major_version == 4:

	import DropsP4PP
	drops = DropsP4PP

	version_check = 1

	try:

		scene.ProcessSomeEvents(1)

	except:

		tkMessageBox.showwarning(title = 'WeirdJuice:Drops', message = 'ProPack SR3+ is required to run this plugin!')
		version_check = 0
		
else:

	import DropsP5
	drops = DropsP5
	version_check = 1


#####################################################################################
# Class: App
#####################################################################################

class App(Frame):

	#############################################################################
	# Instance Initialisation
	#############################################################################

	def __init__(self, master):

		Frame.__init__(self, master)

		self.master = master

		self.grid()

		self.master.title(drops.app_name() + ' v' + str(drops.version()))

		self.master.resizable(0,0)

		self.surface_flag = 0

		self.surface_button_image = PhotoImage(data = drops.surface_button_image_b64())

		self.add_blob_button = Button(self, width = 12, text = "Add Blob", fg = "blue", command = self.add_blob)

		self.add_blob_button.grid(row = 0, column = 0, sticky = W, padx = 5, pady = 2)

		self.add_antiblob_button = Button(self, width = 12, text = "Add Anti-Blob", fg = "red", command = self.add_antiblob)

		self.add_antiblob_button.grid(row = 1, column = 0, sticky = W, padx = 5, pady = 2)

		self.surface_button = Button(self, width = 64, height = 64, image = self.surface_button_image, fg = "black", bd = 4, command = self.surface_button_toggle)


		self.surface_button.grid(row = 0, column = 1, rowspan = 2, sticky = E, padx = 3, pady = 3)

		self.current_frame = scene.Frame()

		self.master.protocol("WM_DELETE_WINDOW", self.quit)

	#############################################################################
	# Method App.quit
	#############################################################################

	def quit(self):

		try:

			if self.surface_flag == 1: 

				self.unsurface()

		except:

			pass

		self.master.destroy()
		self.master.quit()

	################################################################################
	# Method: App::surface_button_toggle
	################################################################################

	def surface_button_toggle(self):

		scene = poser.Scene()

		if self.surface_flag == 0:

			self.add_blob_button.config     (state = DISABLED)
			self.add_antiblob_button.config (state = DISABLED)
			self.surface_button.config      (relief = SUNKEN, fg = "red", bg = "white")
			self.surface()

			self.surface_flag = 1
		
		else:

			self.unsurface()

			self.add_blob_button.config     (state = NORMAL)
			self.add_antiblob_button.config (state = NORMAL)
			self.surface_button.config      (relief = RAISED, fg = "black", bg = "grey75")

			self.surface_flag = 0

		scene.ProcessSomeEvents(1)

	################################################################################
	# Method: App::add_blob
	################################################################################

	def add_blob(self):

		new_blob = drops.create_blob(+1.0)

		scene.ProcessSomeEvents(1)
			
	################################################################################
	# Method: App::add_antiblob
	################################################################################

	def add_antiblob(self):

		new_blob = drops.create_blob(-1.0)

		scene.ProcessSomeEvents(1)

	################################################################################
	# Method: App::surface
	################################################################################

	def surface(self):

		self.grab_set()
		drops.set_surfacing_visibility()
		scene = poser.Scene()
		drops.surface(scene)
		self.current_frame = scene.Frame()
		scene.SetWorldspaceCallback(self.WorldspaceCB)
		scene.DrawAll()
		scene.ProcessSomeEvents(2)
		self.after(250)
		self.grab_release()

	################################################################################
	# Method: App::unsurface
	################################################################################

	def unsurface(self):

		self.grab_set()
		scene = poser.Scene()
		scene.ClearWorldspaceCallback()
		drops.set_unsurfacing_visibility()
		drops.unsurface()
		scene.DrawAll()
		scene.ProcessSomeEvents(2)
		self.after(250)
		self.grab_release()

	################################################################################
	# Method: App::update
	################################################################################

	def update(self):

		scene = poser.Scene()
		scene.ProcessSomeEvents(1)
		root.lift()

		root.after(250, self.update)

	################################################################################
	# Method: App::WorldspaceCB
	################################################################################

	def WorldspaceCB(self, iScene):

		prev_frame = self.current_frame

		# During renders the 'iScene' parameter may be invalid, however
		# the global 'scene' variable is still valid, and works in animations (P4 renderer)

		self.current_frame = scene.Frame()

		if self.current_frame != prev_frame:

			drops.surface(scene)
		

########################################################################################

if version_check:

	app = App(root)

	app.update()

	root.mainloop()

# End of File

